/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.util.ITickable;
import dev.toma.gunsrpg.util.RenderUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.StringTextComponent;

public class ViewSwitchWidget
extends Widget
implements ITickable {
    private static final ResourceLocation BACKGROUND = GunsRPG.makeResource("textures/screen/switch_button.png");
    private final ItemStack icon;
    private Runnable clickEvent = () -> {};
    private int hoverTimer;
    private int primary;
    private int red;
    private int green;
    private int blue;

    public ViewSwitchWidget(int x, int y, int width, int height, ItemStack icon) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.icon = icon;
    }

    public void setColorSchema(int primary, int secondary) {
        this.primary = primary;
        this.red = RenderUtils.red_i(secondary) - RenderUtils.red_i(primary);
        this.green = RenderUtils.green_i(secondary) - RenderUtils.green_i(primary);
        this.blue = RenderUtils.blue_i(secondary) - RenderUtils.blue_i(primary);
    }

    public void setClickEvent(Runnable event) {
        this.clickEvent = Objects.requireNonNull(event);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.clickEvent.run();
    }

    @Override
    public void tick() {
        if (this.hoverTimer > 0) {
            --this.hoverTimer;
        }
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int timer = 8;
        int scale = 2;
        if (this.field_230692_n_) {
            this.hoverTimer = timer;
            scale -= 2;
        }
        float hoverProgress = (float)this.hoverTimer / (float)timer;
        int red = (int)((float)this.red * hoverProgress);
        int green = (int)((float)this.green * hoverProgress);
        int blue = (int)((float)this.blue * hoverProgress);
        int baseRed = RenderUtils.red_i(this.primary);
        int baseGreen = RenderUtils.green_i(this.primary);
        int baseBlue = RenderUtils.blue_i(this.primary);
        int color = 0xFF000000 | baseRed + red << 16 | baseGreen + green << 8 | baseBlue + blue;
        Minecraft client = Minecraft.func_71410_x();
        TextureManager manager = client.func_110434_K();
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        manager.func_110577_a(BACKGROUND);
        RenderUtils.drawColoredTex(pose, this.field_230690_l_ + scale, this.field_230691_m_ + scale, this.field_230690_l_ + this.field_230688_j_ - scale, this.field_230691_m_ + this.field_230689_k_ - scale, color);
        ItemRenderer renderer = client.func_175599_af();
        renderer.func_175042_a(this.icon, this.field_230690_l_ + 8, this.field_230691_m_ + 8);
    }
}

